
#define		uCHAR	unsigned char
#define		uINT	unsigned int

#include <intrins.h>
#include "REG_MG82G5Exx.H"
#include "delay.H"

extern void ReInitial_IHRCO(void);
extern void Initial_AdjIHRCO(void);
extern void Adjust_IHRCO(signed char Step);			// "Step" range: -30 ~ 30(decimal)

void main(void)
{
	Initial_AdjIHRCO();					//Don't remove.

	// Configure MCU output "SYSCLK/10" on T1CKO (P35).
	TMOD = 0x20;
	TH1 = TL1 = 0xFB;
	TR1 = 1;
	AUXR2 = T1X12 | T1CKOE;							

	while(1)
	{
		// P31 key input for 3 step down
		if(P31 == 0)
		{
			Adjust_IHRCO(-3);			// function call for 3 step down

			delay_ms(30);				// P31 key input de-bounce
			while(!P31);
		}
		// P33 key input for 3 step up
		if(P33 == 0)
		{
			Adjust_IHRCO(+3);			// function call for 3 step up
			
			delay_ms(30);				// P33 key input de-bounce
			while(!P33);
		}
		// P34 key input for IHRCO recovery 12MHz
		if(P34 == 0)
		{
			ReInitial_IHRCO();			// function call for IHRCO recovery 12MHz
			
			delay_ms(30);				// P34 key input de-bounce
			while(!P34);
		}
	}
}
